<?php
/*
 * @copyright Copyright (c) 2022 AltumCode (https://altumcode.com/)
 *
 * This software is exclusively sold through https://altumcode.com/ by the AltumCode author.
 * Downloading this product from any other sources and running it without a proper license is illegal,
 *  except the official ones linked from https://altumcode.com/.
 */

return [
    'admin_blog.menu' => 'Blog',
    'admin_blog.main.title' => 'Title',
    'admin_blog.main.description' => 'Description',
    'admin_blog.main.keywords' => 'Meta keywords',
    'admin_blog.main.keywords_help' => 'Comma separated keywords (keyword1, keyword2..etc)',
    'admin_blog.main.image' => 'Featured image',
    'admin_blog.main.url' => 'URL',
    'admin_blog.main.url_placeholder' => 'example',
    'admin_blog.main.language' => 'Language',
    'admin_blog.main.language_all' => 'All',
    'admin_blog.main.order' => 'Order',
    'admin_blog.main.order_help' => 'Easily arrange pages with numbers in ascending order.',
    'admin_blog.main.blog_posts_category_id' => 'Category',
    'admin_blog.main.blog_posts_category_id_null' => 'No category',
    'admin_blog.main.editor' => 'Editor',
    'admin_blog.main.editor_raw' => 'No editor',
    'admin_blog.main.editor_wysiwyg' => 'WYSIWYG',
    'admin_blog.main.editor_confirm' => 'By switching the editor, you will lose your already existing content.',
    'admin_blog.main.content' => 'Content',
    'admin_blog.main.is_published' => 'Is published',
    'admin_blog.error_message.url_exists' => 'This URL alias is already taken.',
    'admin_blog.warning_message.disabled' => 'The blog system is currently disabled. Enable it from the %sWebsite settings page%s.',


    'admin_blog_posts.breadcrumb' => 'Blog posts',
    'admin_blog_posts.title' => 'Blog posts',
    'admin_blog_posts.menu' => 'Posts',
    'admin_blog_posts.header' => 'Blog posts',
    'admin_blog_posts.header_no_data' => 'Create your first blog post',
    'admin_blog_posts.subheader_no_data' => 'Create informational, helpful and quality content for your users.',
    'admin_blog_posts.create' => 'Create post',
    'admin_blog_posts.total_views' => '%s views',
    'admin_blog_posts.table.blog_post' => 'Post',


    'admin_blog_post_create.breadcrumb' => 'Create blog post',
    'admin_blog_post_create.title' => 'Create blog post',
    'admin_blog_post_create.header' => 'Create blog post',


    'admin_blog_post_update.breadcrumb' => 'Edit blog post',
    'admin_blog_post_update.title' => 'Edit blog post',
    'admin_blog_post_update.header' => 'Edit blog post',


    'admin_blog_posts_categories.breadcrumb' => 'Blog posts categories',
    'admin_blog_posts_categories.title' => 'Blog posts categories',
    'admin_blog_posts_categories.menu' => 'Categories',
    'admin_blog_posts_categories.header' => 'Blog posts categories',
    'admin_blog_posts_categories.header_no_data' => 'Create your first blog posts category',
    'admin_blog_posts_categories.subheader_no_data' => 'Separate and categorize your blog posts easily.',
    'admin_blog_posts_categories.create' => 'Create category',
    'admin_blog_posts_categories.table.blog_posts_category' => 'Category',
    'admin_blog_posts_categories.table.blog_posts' => 'View blog posts',


    'admin_blog_posts_category_create.breadcrumb' => 'Create category',
    'admin_blog_posts_category_create.title' => 'Create category',
    'admin_blog_posts_category_create.header' => 'Create category',


    'admin_blog_posts_category_update.breadcrumb' => 'Edit category',
    'admin_blog_posts_category_update.title' => 'Edit category',
    'admin_blog_posts_category_update.header' => 'Edit category',


    'admin_resources.menu' => 'Resources',
    'admin_resources.main.language' => 'Language',
    'admin_resources.main.language_all' => 'All',
    'admin_resources.main.title' => 'Title',
    'admin_resources.main.description' => 'Short description',
    'admin_resources.main.keywords' => 'Meta keywords',
    'admin_resources.main.keywords_help' => 'Comma separated keywords (keyword1, keyword2..etc)',
    'admin_resources.main.url' => 'URL',
    'admin_resources.main.url_placeholder' => 'example',
    'admin_resources.main.url_internal_placeholder' => 'ex: page-url',
    'admin_resources.main.url_external_placeholder' => 'ex: https://domain.com/',
    'admin_resources.main.open_in_new_tab' => 'Open in new tab',
    'admin_resources.main.editor' => 'Editor',
    'admin_resources.main.editor_raw' => 'No editor',
    'admin_resources.main.editor_wysiwyg' => 'WYSIWYG',
    'admin_resources.main.editor_confirm' => 'By switching the editor, you will lose your already existing content.',
    'admin_resources.main.content' => 'Content',
    'admin_resources.main.position' => 'Position',
    'admin_resources.main.position_top' => 'Top menu',
    'admin_resources.main.position_bottom' => 'Bottom menu',
    'admin_resources.main.position_hidden' => 'Hidden',
    'admin_resources.main.type' => 'Type',
    'admin_resources.main.type_internal' => 'Page',
    'admin_resources.main.type_external' => 'Link',
    'admin_resources.main.pages_category_id' => 'Category',
    'admin_resources.main.pages_category_id_null' => 'No category',
    'admin_resources.main.order' => 'Order',
    'admin_resources.main.order_help' => 'Easily arrange with numbers in ascending order.',
    'admin_resources.main.is_published' => 'Is published',
    'admin_resources.error_message.url_exists' => 'This URL alias is already taken.',


    'admin_pages.breadcrumb' => 'Pages',
    'admin_pages.title' => 'Pages',
    'admin_pages.menu' => 'Pages',
    'admin_pages.header' => 'Pages',
    'admin_pages.header_no_data' => 'Create your first page',
    'admin_pages.subheader_no_data' => 'Create additional pages that you can attach to the platform with ease.',
    'admin_pages.create' => 'Create page',
    'admin_pages.table.page' => 'Page',
    'admin_pages.table.total_views' => '%s views',


    'admin_page_create.breadcrumb' => 'Create page',
    'admin_page_create.title' => 'Create page',
    'admin_page_create.header' => 'Create page',


    'admin_page_update.breadcrumb' => 'Edit page',
    'admin_page_update.title' => 'Edit page',
    'admin_page_update.header' => 'Edit page',


    'admin_pages_categories.breadcrumb' => 'Pages categories',
    'admin_pages_categories.menu' => 'Categories',
    'admin_pages_categories.title' => 'Pages categories',
    'admin_pages_categories.header' => 'Pages categories',
    'admin_pages_categories.header_no_data' => 'Create your first page category',
    'admin_pages_categories.subheader_no_data' => 'Sort your additional pages by categories.',
    'admin_pages_categories.create' => 'Create category',
    'admin_pages_categories.table.pages_category' => 'Category',
    'admin_pages_categories.table.pages' => 'View pages',
    'admin_pages_categories.input.icon' => 'Icon',
    'admin_pages_categories.input.icon_placeholder' => 'ex: fa fa-plane',
    'admin_pages_categories.input.icon_help' => 'Font Awesome icon, leave empty for no icon.',


    'admin_pages_category_create.breadcrumb' => 'Create pages category',
    'admin_pages_category_create.title' => 'Create pages category',
    'admin_pages_category_create.header' => 'Create a new pages category',


    'admin_pages_category_update.breadcrumb' => 'Edit pages category',
    'admin_pages_category_update.title' => 'Edit pages category',
    'admin_pages_category_update.header' => 'Edit pages category',


    'admin_plans.breadcrumb' => 'Plans',
    'admin_plans.title' => 'Plans',
    'admin_plans.menu' => 'Plans',
    'admin_plans.header' => 'Plans',
    'admin_plans.create' => 'Create plan',

    'admin_plans.table.name' => 'Plan Name',
    'admin_plans.table.custom_help' => 'Custom plans can be defined directly from the User Edit page.',
    'admin_plans.table.price' => 'Price',
    'admin_plans.table.order' => 'Order',
    'admin_plans.table.monthly' => 'Monthly',
    'admin_plans.table.annual' => 'Annual',
    'admin_plans.table.lifetime' => 'Lifetime',
    'admin_plans.table.users' => 'Users',
    'admin_plans.table.status' => 'Status',

    'admin_plans.main.plan_id' => 'Plan ID',
    'admin_plans.main.name' => 'Name',
    'admin_plans.main.description' => 'Description',
    'admin_plans.main.price' => 'Price',
    'admin_plans.main.custom_contact_value' => 'Contact button value',
    'admin_plans.main.custom_button_url' => 'Contact button URL',
    'admin_plans.main.monthly_price' => 'Monthly Price',
    'admin_plans.main.annual_price' => 'Annual Price',
    'admin_plans.main.lifetime_price' => 'Lifetime deal price',
    'admin_plans.main.price_help' => 'Set 0 to disable the %s',
    'admin_plans.main.color' => 'Color',
    'admin_plans.main.color_help' => 'Set a color to highlight the plan, leave empty for the default color.',
    'admin_plans.main.status' => 'Status',
    'admin_plans.main.order' => 'Order',
    'admin_plans.main.taxes_ids' => 'Applied Taxes',
    'admin_plans.main.taxes_ids_help' => 'Easily select which of your %screated taxes%s you want to apply per plan.',
    'admin_plans.main.codes_ids' => 'Applied Codes',
    'admin_plans.main.codes_ids_help' => 'Easily select which of your %screated codes%s you want to apply per plan.',
    'admin_plans.main.trial_days' => 'Trial days',
    'admin_plans.main.trial_days_help' => 'Set 0 if you do not want to offer a trial for this plan.',
    'admin_plans.main.custom_help' => 'Updating this plan will not affect any users who are on a custom plan. It will only affect the plan displayed on the front-end plans section.',

    'admin_plans.plan.header' => 'Plan settings',
    'admin_plans.plan.subheader' => 'Choose which features to enable for this plan.',
    'admin_plans.plan.unlimited' => 'Set -1 for unlimited.',
    'admin_plans.plan.no_ads' => 'No Ads',
    'admin_plans.plan.no_ads_help' => 'Enabling this will make all people having this plan to not see any ads.',
    'admin_plans.plan.api_is_enabled' => 'API access',
    'admin_plans.plan.api_is_enabled_help' => 'Enable ability for the user to use the REST API.',
    'admin_plans.plan.affiliate_commission_percentage' => 'Affiliate earning percentage',
    'admin_plans.plan.affiliate_commission_percentage_help' => 'Set to 0 to not allow the user to use this feature.',
    'admin_plans.plan.enabled_tools' => 'Enabled tools',
    'admin_plans.plan.enabled_tools_help' => 'Choose which tools you want to give access to.',
    'admin_plans.plan.teams_limit' => 'Teams limit',
    'admin_plans.plan.team_members_limit' => 'Team members limit',


    'admin_plan_delete_modal.header' => 'Delete plan',
    'admin_plan_delete_modal.subheader' => 'By deleting the plan, all the recurring subscriptions of this plan will be cancelled. Users will still have their features they paid for until the Expiration Date of the plan. This action cannot be undone.',


    'admin_plan_create.breadcrumb' => 'Create plan',
    'admin_plan_create.title' => 'Create plan',
    'admin_plan_create.menu' => 'Create plan',
    'admin_plan_create.header' => 'Create a new plan',

    'admin_plan_update.breadcrumb' => 'Edit plan',
    'admin_plan_update.title' => 'Edit plan',
    'admin_plan_update.header' => 'Edit plan',

    'admin_plan_update.update_users_plan_settings.button' => 'Update and update plan subscribers as well',
    'admin_plan_update.update_users_plan_settings.button_help' => 'By updating the plan subscribers you will overwrite all their current settings with the new settings of this plan.',

    'admin_plan_update.error_message.disabled_plans' => 'You are not allowed to disable all the plans which are available (Custom plans are not considered if the payment system is disabled).',


    'admin_codes.breadcrumb' => 'Codes',
    'admin_codes.title' => 'Codes',
    'admin_codes.menu' => 'Codes',
    'admin_codes.header' => 'Codes',
    'admin_codes.header_no_data' => 'Create your first code',
    'admin_codes.subheader_no_data' => 'Create discount codes or fully redeemable codes that you can share to your users.',
    'admin_codes.create' => 'Create code',

    'admin_codes.main.name' => 'Name',
    'admin_codes.main.type' => 'Type',
    'admin_codes.main.type_discount' => 'Discount',
    'admin_codes.main.type_redeemable' => 'Redeemable',
    'admin_codes.main.days' => 'Days',
    'admin_codes.main.days_help' => 'How many days will the plan be available for.',
    'admin_codes.main.code' => 'Code',
    'admin_codes.main.discount' => 'Discount',
    'admin_codes.main.discount_help' => 'Choose a discount between 1% and 99% off for the code',
    'admin_codes.main.quantity' => 'Quantity',
    'admin_codes.main.quantity_help' => 'How many time the code can be used.',
    'admin_codes.main.is_bulk' => 'Bulk generator',
    'admin_codes.main.amount' => 'Amount of unique codes',
    'admin_codes.main.prefix' => 'Prefix for the generated unique codes',
    'admin_codes.main.redeemed' => 'Redeemed',


    'admin_code_create.breadcrumb' => 'Create code',
    'admin_code_create.title' => 'Create code',
    'admin_code_create.menu' => 'Create code',
    'admin_code_create.header' => 'Create a new code',


    'admin_code_update.breadcrumb' => 'Edit code',
    'admin_code_update.title' => 'Edit code',
    'admin_code_update.header' => 'Edit code',
    'admin_code_update.subheader' => 'Changing the settings will not have any effect on already redeemed or used codes.',
    'admin_code_update.subheader2' => 'You can share the code with a shareable link: %s',


    'admin_taxes.breadcrumb' => 'Taxes',
    'admin_taxes.title' => 'Taxes',
    'admin_taxes.menu' => 'Taxes',
    'admin_taxes.header' => 'Taxes',
    'admin_taxes.header_no_data' => 'Create your first tax',
    'admin_taxes.subheader_no_data' => 'Create taxes that you can use and apply to paid plans.',
    'admin_taxes.create' => 'Create tax',


    'admin_taxes.table.tax' => 'Tax',
    'admin_taxes.table.details' => 'Details',
    'admin_taxes.table.billing_type' => 'Billing for',

    'admin_taxes.main.name' => 'Name',
    'admin_taxes.main.description' => 'Description',
    'admin_taxes.main.value' => 'Tax value',
    'admin_taxes.main.value_type' => 'Value Type',
    'admin_taxes.main.value_type_percentage' => 'Percentage',
    'admin_taxes.main.value_type_fixed' => 'Fixed',
    'admin_taxes.main.type' => 'Type',
    'admin_taxes.main.type_inclusive' => 'Inclusive',
    'admin_taxes.main.type_exclusive' => 'Exclusive',
    'admin_taxes.main.billing_type' => 'Billing for',
    'admin_taxes.main.billing_type_personal' => 'Personal only',
    'admin_taxes.main.billing_type_business' => 'Business only',
    'admin_taxes.main.billing_type_both' => 'Personal & Business',
    'admin_taxes.main.billing_type_help' => 'Select for who you want to apply this tax for.',
    'admin_taxes.main.countries' => 'Countries',
    'admin_taxes.main.countries_help' => 'Select the countries that you want to apply this tax on. Leave empty if you want the tax to be applied for all countries.',


    'admin_tax_create.breadcrumb' => 'Create tax',
    'admin_tax_create.title' => 'Create tax',
    'admin_tax_create.menu' => 'Create tax',
    'admin_tax_create.header' => 'Create a new tax',
    'admin_tax_create.subheader' => 'Once a tax is created, it can\'t be edited or deleted. After the tax is created, you can associate it with your created Plans.',


    'admin_tax_update.breadcrumb' => 'Edit tax',
    'admin_tax_update.title' => 'Edit tax',
    'admin_tax_update.header' => 'Edit tax',


    'admin_affiliates_withdrawals.title' => 'Affiliates withdrawals',
    'admin_affiliates_withdrawals.menu' => 'Aff. withdrawals',
    'admin_affiliates_withdrawals.header' => 'Affiliates withdrawals',

    'admin_affiliates_withdrawals.table.user' => 'User',
    'admin_affiliates_withdrawals.table.amount' => 'Amount',
    'admin_affiliates_withdrawals.table.is_paid' => 'Is paid',
    'admin_affiliates_withdrawals.table.is_paid_paid' => 'Paid',
    'admin_affiliates_withdrawals.table.is_paid_pending' => 'Pending',
    'admin_affiliates_withdrawals.table.action_pay_affiliate_withdrawal' => 'Approve withdrawal',


    'admin_affiliate_withdrawal_approve_modal.header' => 'Approve withdrawal',
    'admin_affiliate_withdrawal_approve_modal.subheader' => 'If you approve the withdrawal, the affiliate withdrawal will be considered as completed and the user will get notified via email. Don\'t forget to send their payment.',
    'admin_affiliate_withdrawal_approve_modal.success_message' => 'Affiliate withdrawal request was approved.',


    'admin_payments.title' => 'Payments list',
    'admin_payments.header' => 'Payments list',
    'admin_payments.menu' => 'Payments',

    'admin_payments.table.type' => 'Type',
    'admin_payments.table.plan' => 'Plan',
    'admin_payments.table.user' => 'User',
    'admin_payments.table.total_amount' => 'Total Amount',
    'admin_payments.table.action_view_proof' => 'View proof',
    'admin_payments.table.action_approve_proof' => 'Approve payment',
    'admin_payments.table.invoice' => 'Invoice',

    'admin_payments.filters.status' => 'Status',
    'admin_payments.filters.status_paid' => 'Paid',
    'admin_payments.filters.status_pending' => 'Pending',
    'admin_payments.filters.plan_id' => 'Plan',
    'admin_payments.filters.search_by_payment_id' => 'External Payment ID',
    'admin_payments.filters.order_by_total_amount' => 'Total amount',


    'admin_payment_approve_modal.header' => 'Approve payment',
    'admin_payment_approve_modal.subheader' => 'If you approve the payment, the plan for the user will start.',
    'admin_payment_approve_modal.success_message' => 'Payment approval was performed successfully.',


    'admin_index.title' => 'Admin dashboard',
    'admin_index.menu' => 'Dashboard',
    'admin_index.header' => 'Welcome back, %s 👋',
    'admin_index.support.inactive' => 'You are not eligible for receiving support anymore. %sExtend your support%s now.',
    'admin_index.users' => 'Latest users',
    'admin_index.payments' => 'Latest payments',
    'admin_index.payments_total_amount' => 'Earned',


    'admin_users.breadcrumb' => 'Users',
    'admin_users.title' => 'Users',
    'admin_users.header' => 'Users',
    'admin_users.menu' => 'Users',


    'admin_users.table.user' => 'User',
    'admin_users.table.details' => 'Details',
    'admin_users.table.datetime' => 'Registration date: %s',
    'admin_users.table.last_activity' => 'Last activity: %s',
    'admin_users.table.total_logins' => 'Total logins: %s',

    'admin_users.main.user_id' => 'User ID',
    'admin_users.main.plan_id' => 'Plan',
    'admin_users.main.plan_expiration_date' => 'Plan expiration date',
    'admin_users.main.name' => 'Name',
    'admin_users.main.email' => 'Email',
    'admin_users.main.password' => 'Password',
    'admin_users.main.type' => 'Privileges',
    'admin_users.main.type_help' => 'Admin users will have the same privileges as you, be careful!',
    'admin_users.main.type_admin' => 'Admin',
    'admin_users.main.type_user' => 'User',
    'admin_users.main.source' => 'Source',
    'admin_users.main.source.direct' => 'Direct sign up',
    'admin_users.main.source.admin_create' => 'Admin created',
    'admin_users.main.source.admin_api_create' => 'Admin API created',
    'admin_users.main.source.facebook' => 'Facebook login',
    'admin_users.main.source.google' => 'Google login',
    'admin_users.main.source.discord' => 'Discord login',
    'admin_users.main.source.twitter' => 'Twitter login',
    'admin_users.main.status' => 'Status',
    'admin_users.main.status_active' => 'Active',
    'admin_users.main.status_disabled' => 'Disabled',
    'admin_users.main.status_unconfirmed' => 'Unconfirmed',
    'admin_users.main.datetime' => 'Registration date',
    'admin_users.main.total_logins' => 'Total logins',
    'admin_users.main.country' => 'Country',
    'admin_users.main.country_unknown' => 'Unknown country',
    'admin_users.main.ip' => 'IP',
    'admin_users.main.api_key' => 'API Key',
    'admin_users.main.last_activity' => 'Last active',
    'admin_users.main.last_user_agent' => 'Last User Agent',
    'admin_users.main.plan_trial_done' => 'Trial is done',
    'admin_users.main.payment_subscription_id' => 'Last subscription id',
    'admin_users.main.payment_processor' => 'Last payment processor',
    'admin_users.main.payment_total_amount' => 'Last payment amount',
    'admin_users.main.referral_key' => 'Referral key',
    'admin_users.main.referred_by' => 'Referred by',
    'admin_users.main.language' => 'Language',
    'admin_users.main.timezone' => 'Timezone',
    'admin_users.main.twofa_is_enabled' => 'Two-factor authentication',
    'admin_users.main.anti_phishing_code' => 'Anti phishing code',

    'admin_users.error_message.self_delete' => 'You can\'t delete yourself.',
    'admin_users.error_message.name_length' => 'The name field must be between 1 and 64 characters.',
    'admin_users.error_message.email_exists' => 'This email is already used by another account.',


    'admin_user_login_modal.header' => 'Login as this user',
    'admin_user_login_modal.subheader' => 'By logging in as another user, you will be logged out of the current account and fully logged in to this user.',
    'admin_user_login_modal.success_message' => 'Successfully logged in as %s! To get out of this account simply use the logout function.',


    'admin_user_create.breadcrumb' => 'Create user',
    'admin_user_create.title' => 'Create user',
    'admin_user_create.header' => 'Create user',
    'admin_user_create.menu' => 'Create user',


    'admin_user_update.breadcrumb' => 'Edit user',
    'admin_user_update.title' => 'Edit user',
    'admin_user_update.header' => 'Edit user',

    'admin_user_update.plan.header' => 'Plan',
    'admin_user_update.plan.plan_expiration_date_invalid' => 'You must set the plan expiration date some time in the future.',

    'admin_user_update.change_password.header' => 'Change password',
    'admin_user_update.change_password.subheader' => 'Leave it empty if you don\'t want to change the user\'s password!',
    'admin_user_update.change_password.new_password' => 'New password',
    'admin_user_update.change_password.repeat_password' => 'Repeat password',


    'admin_user_view.breadcrumb' => 'View user',
    'admin_user_view.title' => 'View user',
    'admin_user_view.header' => 'View user',
    'admin_user_view.billing' => 'Billing details',
    'admin_user_view.qr_codes' => 'QR codes',
    'admin_user_view.links' => 'Links',
    'admin_user_view.pixels' => 'Pixels',
    'admin_user_view.projects' => 'Projects',
    'admin_user_view.payments' => 'Payments',
    'admin_user_view.domains' => 'Custom Domains',
    'admin_user_view.users_logs' => 'Logs',
    'admin_user_view.redeemed_codes' => 'Redeemed codes',
    'admin_user_view.referred_by' => 'Referrals',
    'admin_user_view.teams' => 'Teams',


    'admin_users_logs.title' => 'Users logs',
    'admin_users_logs.header' => 'Users logs',
    'admin_users_logs.menu' => 'Users logs',

    'admin_users_logs.table.user' => 'User',
    'admin_users_logs.table.type' => 'Type',
    'admin_users_logs.table.ip' => 'IP',
    'admin_users_logs.table.details' => 'Details',


    'admin_redeemed_codes.title' => 'Redeemed codes',
    'admin_redeemed_codes.header' => 'Redeemed codes',
    'admin_redeemed_codes.menu' => 'Redeemed codes',

    'admin_redeemed_codes.table.user' => 'User',
    'admin_redeemed_codes.table.code' => 'Code',


    'admin_settings.title' => 'Settings',
    'admin_settings.menu' => 'Settings',
    'admin_settings.header' => 'Settings',
    'admin_settings.documentation' => 'Read the <a href="https://altumco.de/66toolkit-docs" target="_blank">Documentation</a> to get more details on certain available configurations.',
    'admin_settings.payment_processors' => 'Payment processors',
    'admin_settings.social_logins' => 'Social logins',

    'admin_settings.main.tab' => 'Main',
    'admin_settings.main.title' => 'Website title',
    'admin_settings.main.default_language' => 'Default language',
    'admin_settings.main.default_language_help' => 'To add more languages, please consult the documentation.',
    'admin_settings.main.default_theme_style' => 'Default theme style',
    'admin_settings.main.logo_light' => 'Logo for light theme',
    'admin_settings.main.logo_dark' => 'Logo for dark theme',
    'admin_settings.main.logo_email' => 'Logo for sent emails',
    'admin_settings.main.favicon' => 'Favicon',
    'admin_settings.main.opengraph' => 'Opengraph image',
    'admin_settings.main.se_indexing' => 'Allow search engines indexing',
    'admin_settings.main.display_index_plans' => 'Display plans on the index page',
    'admin_settings.main.default_timezone' => 'Default timezone',
    'admin_settings.main.default_timezone_help' => 'The default timezone for users when they are registering (they can change it later on).',
    'admin_settings.main.index_url' => 'Custom landing page URL',
    'admin_settings.main.index_url_help' => 'Disable the original landing page & redirect to a new one. Leave empty to disable.',
    'admin_settings.main.not_found_url' => 'Custom 404 page URL',
    'admin_settings.main.not_found_url_help' => 'Disable the original 404 not found page & redirect to a new one. Leave empty to disable.',
    'admin_settings.main.terms_and_conditions_url' => 'Terms and Conditions URL',
    'admin_settings.main.terms_and_conditions_url_help' => 'Link to the terms and conditions of the website. Can be a link created with the Pages creator from the sidebar.',
    'admin_settings.main.privacy_policy_url' => 'Privacy Policy URL',
    'admin_settings.main.privacy_policy_url_help' => 'Link to the privacy policy of the website. Can be a link created with the Pages creator from the sidebar.',
    'admin_settings.main.default_results_per_page' => 'Default results per page',
    'admin_settings.main.default_order_type' => 'Default results order',
    'admin_settings.main.auto_language_detection_is_enabled' => 'Auto Language Detection',
    'admin_settings.main.auto_language_detection_is_enabled_help' => 'Your visitors will be automatically redirected to their browser\'s language, if that particular language is available on your site.',
    'admin_settings.main.blog_is_enabled' => 'Enable blog system',

    'admin_settings.users.tab' => 'Users',
    'admin_settings.users.email_confirmation' => 'Email confirmation',
    'admin_settings.users.email_confirmation_help' => 'Send out email confirmation when a user registers or changes his email address.',
    'admin_settings.users.register_is_enabled' => 'Enable new users registration',
    'admin_settings.users.register_is_enabled_help' => 'Allow people to register on your platform or completely disable the register page.',
    'admin_settings.users.auto_delete_unconfirmed_users' => 'Auto delete unconfirmed users',
    'admin_settings.users.auto_delete_unconfirmed_users_help' => 'The amount of days it take for a user to be deleted if unconfirmed, no reminders will be sent as they are unconfirmed users. Set 0 to disable this feature.',
    'admin_settings.users.auto_delete_inactive_users' => 'Auto delete inactive users',
    'admin_settings.users.auto_delete_inactive_users_help' => 'The amount of days it take for a user to be deleted if inactive (only valid for Free users). Set 0 to disable this feature.',
    'admin_settings.users.user_deletion_reminder' => 'User deletion reminder',
    'admin_settings.users.user_deletion_reminder_help' => 'How many days prior should the user get reminded that his account is going to be deleted for inactivity. Set 0 to disable the reminder.',
    'admin_settings.users.blacklisted_domains' => 'Blacklisted domains',
    'admin_settings.users.blacklisted_domains_help' => 'Comma separated values of domains ( word1, word2, word3 ..etc ). People will not be able to register with any domains included in this list.',
    'admin_settings.users.blacklisted_countries' => 'Select blacklisted countries',
    'admin_settings.users.blacklisted_countries_help' => 'Select the countries that you want to blacklist from registering to the system. Detection is IP based.',

    'admin_settings.payment.tab' => 'Payment',
    'admin_settings.payment.is_enabled' => 'Enable Payments System',
    'admin_settings.payment.is_enabled_help' => 'Disabling the payment system will remove all the options for the users to upgrade their accounts or see any payment related information.',
    'admin_settings.payment.type' => 'Enabled payment types',
    'admin_settings.payment.type_help' => '',
    'admin_settings.payment.type_one_time' => 'One Time',
    'admin_settings.payment.type_recurring' => 'Recurring',
    'admin_settings.payment.type_both' => 'Both',
    'admin_settings.payment.brand_name' => 'Brand Name',
    'admin_settings.payment.brand_name_help' => 'The brand name will be used for displaying the brand when users purchase via payment gates. (ex: paypal)',
    'admin_settings.payment.currency' => 'Currency',
    'admin_settings.payment.currency_help' => 'Currency code for the payments (ex: USD, EUR, CAD). Make sure the currency code is supported by your payment processor.',
    'admin_settings.payment.codes_is_enabled' => 'Enable Discount/Redeemable Codes',
    'admin_settings.payment.codes_is_enabled_help' => 'Enabling the discount codes system will enable users to add a discount code created from the admin panel, before they checkout.',
    'admin_settings.payment.taxes_and_billing_is_enabled' => 'Enable Taxes & Billing system',
    'admin_settings.payment.taxes_and_billing_is_enabled_help' => 'Enabling this feature will require users to fill in their Billing info before checking out and you will also be able to create taxes for each created plan.',
    'admin_settings.payment.invoice_is_enabled' => 'Enable Invoices System',
    'admin_settings.payment.invoice_is_enabled_help' => 'This option will determine if users will be able to see invoices for their payments or not.',
    'admin_settings.payment.webhook_url' => 'Webhook URL',

    'admin_settings.paypal.tab' => 'Paypal',
    'admin_settings.paypal.is_enabled' => 'Enable Paypal payments',
    'admin_settings.paypal.mode' => 'Mode',
    'admin_settings.paypal.mode_help' => 'live - production, sandbox - testing purposes',
    'admin_settings.paypal.client_id' => 'Client Id',
    'admin_settings.paypal.secret' => 'Secret',

    'admin_settings.stripe.tab' => 'Stripe',
    'admin_settings.stripe.is_enabled' => 'Enable Stripe payments',
    'admin_settings.stripe.publishable_key' => 'Publishable Key',
    'admin_settings.stripe.secret_key' => 'Secret Key',
    'admin_settings.stripe.webhook_secret' => 'Webhook Secret',

    'admin_settings.offline_payment.tab' => 'Offline payment',
    'admin_settings.offline_payment.is_enabled' => 'Enable offline payments',
    'admin_settings.offline_payment.instructions' => 'Instructions',
    'admin_settings.offline_payment.instructions_help' => 'Payment instructions for the user to see, before submitting the payment.',

    'admin_settings.coinbase.tab' => 'Coinbase',
    'admin_settings.coinbase.is_enabled' => 'Enable Coinbase payments',
    'admin_settings.coinbase.api_key' => 'API Key',
    'admin_settings.coinbase.webhook_secret' => 'Webhook Secret',

    'admin_settings.payu.tab' => 'PayU',
    'admin_settings.payu.is_enabled' => 'Enable PayU payments',
    'admin_settings.payu.mode' => 'Mode',
    'admin_settings.payu.merchant_pos_id' => 'Merchant POS Id',
    'admin_settings.payu.signature_key' => 'Signature Key',
    'admin_settings.payu.oauth_client_id' => 'Oauth Client Id',
    'admin_settings.payu.oauth_client_secret' => 'Oauth Client Secret',

    'admin_settings.paystack.tab' => 'Paystack',
    'admin_settings.paystack.is_enabled' => 'Enable Paystack payments',
    'admin_settings.paystack.public_key' => 'Public Key',
    'admin_settings.paystack.secret_key' => 'Secret Key',

    'admin_settings.razorpay.tab' => 'Razorpay',
    'admin_settings.razorpay.is_enabled' => 'Enable Razorpay payments',
    'admin_settings.razorpay.key_id' => 'Key Id',
    'admin_settings.razorpay.key_secret' => 'Key Secret',
    'admin_settings.razorpay.webhook_secret' => 'Webhook Secret',

    'admin_settings.mollie.tab' => 'Mollie',
    'admin_settings.mollie.is_enabled' => 'Enable Mollie payments',
    'admin_settings.mollie.api_key' => 'API Key',

    'admin_settings.yookassa.tab' => 'Yookassa',
    'admin_settings.yookassa.is_enabled' => 'Enable Yookassa payments',
    'admin_settings.yookassa.shop_id' => 'Shop ID',
    'admin_settings.yookassa.secret_key' => 'Secret Key',

    'admin_settings.crypto_com.tab' => 'Crypto.com',
    'admin_settings.crypto_com.is_enabled' => 'Enable Crypto.com payments',
    'admin_settings.crypto_com.publishable_key' => 'Publishable Key',
    'admin_settings.crypto_com.secret_key' => 'Secret Key',
    'admin_settings.crypto_com.webhook_secret' => 'Webhook Secret',

    'admin_settings.paddle.tab' => 'Paddle',
    'admin_settings.paddle.is_enabled' => 'Enable Paddle payments',
    'admin_settings.paddle.mode' => 'Mode',
    'admin_settings.paddle.vendor_id' => 'Vendor ID',
    'admin_settings.paddle.api_key' => 'API Key',
    'admin_settings.paddle.public_key' => 'Public Key',

    'admin_settings.affiliate.tab' => 'Affiliate',
    'admin_settings.affiliate.is_enabled' => 'Enable the affiliate system',
    'admin_settings.affiliate.is_enabled_help' => 'The affiliate system will enable your users to get paid for bringing other paying users to your platform.',
    'admin_settings.affiliate.commission_type' => 'Commission type',
    'admin_settings.affiliate.commission_type_once' => 'Once - give out commission for the first payment of a referred user',
    'admin_settings.affiliate.commission_type_forever' => 'Forever - give out commission for all the payments of a referred user',
    'admin_settings.affiliate.minimum_withdrawal_amount' => 'Minimum withdrawal amount',
    'admin_settings.affiliate.minimum_withdrawal_amount_help' => 'How much does a user need to have in his balance until he can request a withdrawal.',
    'admin_settings.affiliate.withdrawal_notes' => 'Withdrawal request notes',
    'admin_settings.affiliate.withdrawal_notes_help' => 'Inform your users about the withdrawal process. You can request them to write in their bank account or Paypal email for example.',

    'admin_settings.business.tab' => 'Business',
    'admin_settings.business.subheader' => 'These details will be used when generating invoices for the user.',
    'admin_settings.business.brand_name' => 'Brand name',
    'admin_settings.business.invoice_nr_prefix' => 'Invoice Nr Prefix',
    'admin_settings.business.invoice_nr_prefix_help' => 'Your Nr Prefix for all the invoices generated on the system. Ex: INV-',
    'admin_settings.business.name' => 'Name',
    'admin_settings.business.address' => 'Address',
    'admin_settings.business.city' => 'City',
    'admin_settings.business.county' => 'County',
    'admin_settings.business.zip' => 'ZIP',
    'admin_settings.business.country' => 'Country',
    'admin_settings.business.email' => 'Email',
    'admin_settings.business.phone' => 'Phone',
    'admin_settings.business.tax_type' => 'Tax Type',
    'admin_settings.business.tax_type_placeholder' => 'ex: VAT',
    'admin_settings.business.tax_id' => 'Tax ID',
    'admin_settings.business.custom_key_one' => 'Custom Field Name',
    'admin_settings.business.custom_value_one' => 'Custom Field Value',
    'admin_settings.business.custom_key_two' => 'Custom Field Name',
    'admin_settings.business.custom_value_two' => 'Custom Field Value',

    'admin_settings.captcha.tab' => 'Captcha',
    'admin_settings.captcha.type' => 'Captcha provider',
    'admin_settings.captcha.type.basic' => 'Basic captcha (self-hosted)',
    'admin_settings.captcha.type.recaptcha' => 'Google ReCaptcha v2 checkbox',
    'admin_settings.captcha.type.hcaptcha' => 'hCaptcha',
    'admin_settings.captcha.type.turnstile' => 'Cloudflare Turnstile',
    'admin_settings.captcha.recaptcha_public_key' => 'ReCaptcha Public Key',
    'admin_settings.captcha.recaptcha_private_key' => 'ReCaptcha Private Key',
    'admin_settings.captcha.hcaptcha_site_key' => 'hCaptcha Site Key',
    'admin_settings.captcha.hcaptcha_secret_key' => 'hCaptcha Secret Key',
    'admin_settings.captcha.turnstile_site_key' => 'Turnstile Site Key',
    'admin_settings.captcha.turnstile_secret_key' => 'Turnstile Secret Key',
    'admin_settings.captcha.login_is_enabled' => 'Enable captcha on the login page',
    'admin_settings.captcha.register_is_enabled' => 'Enable captcha on the register page',
    'admin_settings.captcha.lost_password_is_enabled' => 'Enable captcha on the lost password page',
    'admin_settings.captcha.resend_activation_is_enabled' => 'Enable captcha on the resend activation page',
    'admin_settings.captcha.contact_is_enabled' => 'Enable captcha on the contact page',

    'admin_settings.facebook.tab' => 'Facebook Login',
    'admin_settings.facebook.is_enabled' => 'Enable Facebook Login',
    'admin_settings.facebook.app_id' => 'App Id',
    'admin_settings.facebook.app_secret' => 'App Secret',

    'admin_settings.google.tab' => 'Google Login',
    'admin_settings.google.is_enabled' => 'Enable Google Login',
    'admin_settings.google.client_id' => 'Client Id',
    'admin_settings.google.client_secret' => 'Client Secret',

    'admin_settings.twitter.tab' => 'Twitter Login',
    'admin_settings.twitter.is_enabled' => 'Enable Twitter Login',
    'admin_settings.twitter.consumer_api_key' => 'Consumer API Key',
    'admin_settings.twitter.consumer_api_secret' => 'Consumer API Secret',

    'admin_settings.discord.tab' => 'Discord Login',
    'admin_settings.discord.is_enabled' => 'Enable Discord Login',
    'admin_settings.discord.client_id' => 'Client ID',
    'admin_settings.discord.client_secret' => 'Client Secret',

    'admin_settings.cookie_consent.tab' => 'Cookie consent',
    'admin_settings.cookie_consent.is_enabled' => 'Enable cookie consent',
    'admin_settings.cookie_consent.is_enabled_help' => 'Cookie consent is made possible with the <a href="https://github.com/orestbida/cookieconsent" target="_blank">orestbida/cookieconsent</a> library. If you add your own custom js and want to make it work with this, <a href="https://github.com/orestbida/cookieconsent#how-to-blockmanage-scripts" target="_blank">read this</a>.',
    'admin_settings.cookie_consent.logging_is_enabled' => 'Enable logging',
    'admin_settings.cookie_consent.logging_is_enabled_help' => 'Enable this will log all the users and their selected cookie consent preferences into a CSV file.',
    'admin_settings.cookie_consent.logging_download' => 'Download consent log',
    'admin_settings.cookie_consent.necessary_is_enabled' => 'Strictly necessary cookies',
    'admin_settings.cookie_consent.analytics_is_enabled' => 'Performance and Analytics cookies',
    'admin_settings.cookie_consent.targeting_is_enabled' => 'Advertisement and Targeting cookies',
    'admin_settings.cookie_consent.layout' => 'Layout type',
    'admin_settings.cookie_consent.position_y' => 'Position Y',
    'admin_settings.cookie_consent.position_x' => 'Position X',

    'admin_settings.socials.tab' => 'Socials',
    'admin_settings.socials.help' => 'Social links to be displayed in the footer of the website.',

    'admin_settings.smtp.tab' => 'SMTP',
    'admin_settings.smtp.host' => 'Host',
    'admin_settings.smtp.host_help' => 'If there are no values entered in this field then the system will try to use the default mail function.',
    'admin_settings.smtp.from' => 'From email',
    'admin_settings.smtp.from_help' => 'The email that the users get the email from / the \'reply-to\' email.',
    'admin_settings.smtp.from_name' => 'From name',
    'admin_settings.smtp.from_name_help' => 'The name associated with the email below.',
    'admin_settings.smtp.encryption' => 'Encryption',
    'admin_settings.smtp.port' => 'Port',
    'admin_settings.smtp.auth' => 'Authentication',
    'admin_settings.smtp.username' => 'Username',
    'admin_settings.smtp.password' => 'Password',

    'admin_settings.custom.tab' => 'Custom JS / CSS',
    'admin_settings.custom.head_js' => 'App head Javascript',
    'admin_settings.custom.head_js_help' => 'Add your own tracking js code ( ex: Google Analytics ).',
    'admin_settings.custom.head_css' => 'App custom CSS',
    'admin_settings.custom.head_css_help' => 'Add custom CSS in case you want to overwrite certain styles of the website.',

    'admin_settings.announcements.tab' => 'Announcements',
    'admin_settings.announcements.guests' => 'Guests',
    'admin_settings.announcements.users' => 'Users',
    'admin_settings.announcements.content' => 'Announcement content',
    'admin_settings.announcements.content_help' => 'This field accepts text, html or javascript. Leave empty to disable.',
    'admin_settings.announcements.text_color' => 'Text color',
    'admin_settings.announcements.background_color' => 'Background color',

    'admin_settings.email_notifications.tab' => 'Email Notifications',
    'admin_settings.email_notifications.emails' => 'Emails to be notified',
    'admin_settings.email_notifications.emails_help' => 'Emails that will receive a notification when one of the actions from below are performed. Add valid email addresses separated by a comma.',
    'admin_settings.email_notifications.new_user' => 'New User',
    'admin_settings.email_notifications.new_user_help' => 'Receive an email when a new users registers to the website.',
    'admin_settings.email_notifications.delete_user' => 'Delete User',
    'admin_settings.email_notifications.delete_user_help' => 'Receive an email when any user deletes their account.',
    'admin_settings.email_notifications.new_payment' => 'New Payment',
    'admin_settings.email_notifications.new_payment_help' => 'Receive an email when a new payment is successfully processed.',
    'admin_settings.email_notifications.contact' => 'Contact page emails',
    'admin_settings.email_notifications.contact_help' => 'Enable the contact system.',
    'admin_settings.email_notifications.new_affiliate_withdrawal' => 'New affiliate withdrawal',
    'admin_settings.email_notifications.new_affiliate_withdrawal_help' => 'Receive an email when a new affiliate withdrawal request is submitted.',

    'admin_settings.offload.tab' => 'Offload',
    'admin_settings.offload.assets_url' => 'Assets URL',
    'admin_settings.offload.assets_url_help' => 'Full URL to the assets folder from any storage provider, such as: Amazon S3, DigitalOcean Spaces.',
    'admin_settings.offload.provider' => 'Storage provider',
    'admin_settings.offload.uploads_url' => 'Uploads URL',
    'admin_settings.offload.uploads_url_help' => 'Full URL to the uploads folder from any storage provider, such as: Amazon S3, DigitalOcean Spaces.',
    'admin_settings.offload.endpoint_url' => 'Endpoint URL',
    'admin_settings.offload.access_key' => 'Access key',
    'admin_settings.offload.secret_access_key' => 'Secret access key',
    'admin_settings.offload.storage_name' => 'Bucket name',
    'admin_settings.offload.region' => 'Region',

    'admin_settings.webhooks.tab' => 'Webhooks',
    'admin_settings.webhooks.help' => 'Send a webhook POST request to the above URL with the %s form data values when this event is triggered.',
    'admin_settings.webhooks.user_new' => 'New users event - webhook URL',
    'admin_settings.webhooks.user_delete' => 'User deletion event - webhook URL',
    'admin_settings.webhooks.payment_new' => 'New payment event - webhook URL',
    'admin_settings.webhooks.code_redeemed' => 'Code redeemed event - webhook URL',
    'admin_settings.webhooks.contact' => 'Contact form - webhook URL',

    'admin_settings.cron.tab' => 'Cron',
    'admin_settings.cron.last_execution' => 'Last executed %s',
    'admin_settings.cron.reset' => 'Reset cron job',

    'admin_settings.cache.tab' => 'Cache',
    'admin_settings.cache.help' => 'This is a page meant for more advanced users, simply ignore it if you don\'t understand what cache is.',
    'admin_settings.cache.size' => 'Current cache size',
    'admin_settings.cache.clear' => 'Clear cache',

    'admin_settings.license.tab' => 'License',
    'admin_settings.license.license' => 'License',
    'admin_settings.license.license_help' => 'The license you got from purchasing the product.',
    'admin_settings.license.type' => 'License type',
    'admin_settings.license.new_license' => 'New license',
    'admin_settings.license.new_license_help' => 'Leave empty if you don\'t want to change it. Useful when changing your license or upgrading to a new one (ex: from Regular License to Extended).',

    'admin_settings.support.tab' => 'Support',
    'admin_settings.support.status' => 'Status',
    'admin_settings.support.status.active' => 'Active. Will expire on %s.',
    'admin_settings.support.status.active.help' => 'You are eligible for receiving support via support@altumcode.com',
    'admin_settings.support.status.inactive' => 'Inactive. Expired on %s.',
    'admin_settings.support.status.inactive.help' => 'You are not eligible for receiving support anymore.',
    'admin_settings.support.status.unknown.help' => 'No data available, get your support status with the button below.',
    'admin_settings.support.extend' => 'Extend your support',
    'admin_settings.support.submit' => 'Get support status',

    'admin_settings.ads.tab' => 'Ads',
    'admin_settings.ads.ads_help' => 'Ads to show users that do not have a plan with the \'No ads\' plan feature enabled. These fields accept text, html or javascript.',
    'admin_settings.ads.header' => 'App header',
    'admin_settings.ads.footer' => 'App footer',

    'admin_settings.tools.tab' => 'Tools',
    'admin_settings.tools.available_tools' => 'Available tools',
    'admin_settings.tools.google_safe_browsing_is_enabled' => 'Google Safe Browsing API',
    'admin_settings.tools.google_safe_browsing_is_enabled_help' => 'Check all the URLs that the user adds via their links to make sure that they are not malicious / dangerous sites.',
    'admin_settings.tools.google_safe_browsing_api_key' => 'API Key',

    'admin_settings_send_test_email_modal.header' => 'Send test email',
    'admin_settings_send_test_email_modal.email' => 'Email to send to',
    'admin_settings_send_test_email_modal.success_message' => 'We sent the email commands to your SMTP without receiving any errors.',
    'admin_settings_send_test_email_modal.error_message' => 'We sent the email commands to your SMTP, but we have received the following errors: %s',


    'admin_teams.title' => 'Teams',
    'admin_teams.header' => 'Teams',
    'admin_teams.menu' => 'Teams',
    'admin_teams.table.user' => 'User',
    'admin_teams.table.name' => 'Name',


    'admin_plugins.title' => 'Plugins',
    'admin_plugins.menu' => 'Plugins',
    'admin_plugins.header' => 'Plugins',
    'admin_plugins.header_no_data' => 'No plugins available',
    'admin_plugins.subheader_no_data' => 'There are no plugins available for now :(.',
    'admin_plugins.no_access' => 'You must own, install & activate the \'%s\' plugin to use this feature.',
    'admin_plugins.install' => 'Install',
    'admin_plugins.uninstall' => 'Uninstall',
    'admin_plugins.activate' => 'Activate',
    'admin_plugins.disable' => 'Disable',
    'admin_plugins.status_inexistent' => 'Get plugin',
    'admin_plugins.status_uninstalled' => 'Uninstalled',
    'admin_plugins.status_active' => 'Active',
    'admin_plugins.status_disabled' => 'Disabled',
    'admin_plugins.settings' => 'Settings',

    'admin_plugins.table.plugin' => 'Plugin',
    'admin_plugins.table.author' => 'Author',
    'admin_plugins.table.status' => 'Status',
    'admin_plugins.install_message' => '%s has been successfully installed.',
    'admin_plugins.uninstall_message' => '%s has been successfully uninstalled.',
    'admin_plugins.activate_message' => '%s has been successfully activated.',
    'admin_plugins.disable_message' => '%s has been successfully disabled.',


    'admin_plugin_uninstall_modal.header' => 'Uninstall plugin',
    'admin_plugin_uninstall_modal.subheader' => 'By uninstalling the plugin, all the potential data related to the plugin will be removed from the system.',


    'admin_plugin_delete_modal.header' => 'Delete plugin',
    'admin_plugin_delete_modal.subheader' => 'To delete the plugin, simply go into the <strong>plugins</strong> folder and delete the plugin.',


    'admin_languages.breadcrumb' => 'Languages',
    'admin_languages.title' => 'Languages',
    'admin_languages.menu' => 'Languages',
    'admin_languages.header' => 'Languages',
    'admin_languages.header_no_data' => 'No languages available',
    'admin_languages.main_settings' => 'Main settings',
    'admin_languages.translate_app' => 'Translate app',
    'admin_languages.translate_admin' => 'Translate admin',
    'admin_languages.main.language_name' => 'Language',
    'admin_languages.main.language_name_help' => 'The name of the language, such as: French, Italian...etc.',
    'admin_languages.main.language_code' => 'Language code',
    'admin_languages.main.language_code_help' => 'The ISO 639-1 language code, such as: fr, it...etc.',
    'admin_languages.main.status' => 'Status',
    'admin_languages.main.display' => 'Display type',
    'admin_languages.main.display_all' => 'All',
    'admin_languages.main.display_translated' => 'Translated',
    'admin_languages.main.display_not_translated' => 'Not translated',
    'admin_languages.main.main' => 'Main language',
    'admin_languages.main.default_language' => 'Default language',
    'admin_languages.info_message.max_input_vars' => 'Your PHP settings (max_input_vars) allow you to submit %1$s fields at one time. Read the documentation FAQ.',
    'admin_languages.info_message.total' => 'There are currently %1$s translated strings out of %2$s.',
    'admin_languages.info_message.main' => 'The main language will always be replaced with releases of new updates. If you want to avoid this, create a new language file and disable this one.',
    'admin_languages.error_message.language_exists' => '%1$s (%2$s) language already exists.',


    'admin_language_create.breadcrumb' => 'Create language',
    'admin_language_create.title' => 'Create language',
    'admin_language_create.header' => 'Create language',
    'admin_language_create.subheader' => 'You can translate the new language after it\'s creation.',
    'admin_language_create.menu' => 'Create language',


    'admin_language_update.breadcrumb' => 'Edit language',
    'admin_language_update.title' => 'Edit language',
    'admin_language_update.header' => 'Edit language',


    'admin_statistics.title' => 'Statistics',
    'admin_statistics.menu' => 'Statistics',
    'admin_statistics.header' => 'Statistics',
    'admin_statistics.subheader' => 'See how your website evolves throughout time.',

    'admin_statistics.payments.menu' => 'Payments',
    'admin_statistics.payments.header' => 'Sales',
    'admin_statistics.payments.subheader' => 'This website has generated %s %s revenue on %s sales.',
    'admin_statistics.payments.chart_total_payments' => 'Total sales',
    'admin_statistics.payments.chart_total_amount' => 'Total earned',

    'admin_statistics.affiliates_commissions.menu' => 'Aff. Commissions',
    'admin_statistics.affiliates_commissions.header' => 'Affiliates commissions',
    'admin_statistics.affiliates_commissions.chart_total_affiliates_commissions' => 'Total affiliates commissions',
    'admin_statistics.affiliates_commissions.chart_amount' => 'Total amount',

    'admin_statistics.affiliates_withdrawals.menu' => 'Aff. Withdrawals',
    'admin_statistics.affiliates_withdrawals.header' => 'Affiliates withdrawals',
    'admin_statistics.affiliates_withdrawals.chart_total_affiliates_withdrawals' => 'Total affiliates withdrawals',
    'admin_statistics.affiliates_withdrawals.chart_amount' => 'Total amount',

    'admin_statistics.growth.menu' => 'Growth',

    'admin_statistics.growth.users.header' => 'New registered users',
    'admin_statistics.growth.users.chart' => 'Users',

    'admin_statistics.growth.users_logs.header' => 'Active users',
    'admin_statistics.growth.users_logs.chart' => 'Active users',

    'admin_statistics.growth.redeemed_codes.header' => 'Redeemed codes',
    'admin_statistics.growth.redeemed_codes.chart' => 'Codes',

    'admin_statistics.qr_codes.menu' => 'QR codes',
    'admin_statistics.qr_codes.header' => 'QR codes',
    'admin_statistics.qr_codes.chart' => 'New QR codes',

    'admin_statistics.links.menu' => 'Links',
    'admin_statistics.links.header' => 'Links',
    'admin_statistics.links.chart' => 'New links',

    'admin_statistics.statistics.menu' => 'Links statistics',
    'admin_statistics.statistics.header' => 'Links statistics',
    'admin_statistics.statistics.chart' => 'Pageviews',

    'admin_statistics.projects.menu' => 'Projects',
    'admin_statistics.projects.header' => 'Projects',
    'admin_statistics.projects.chart' => 'New projects',

    'admin_statistics.pixels.menu' => 'Pixels',
    'admin_statistics.pixels.header' => 'Pixels',
    'admin_statistics.pixels.chart' => 'New pixels',

    'admin_statistics.domains.menu' => 'Domains',
    'admin_statistics.domains.header' => 'Domains',
    'admin_statistics.domains.chart' => 'New domains',

    'admin_api_documentation.menu' => 'API docs',
    'admin_api_documentation.title' => 'Admin API documentation',
    'admin_api_documentation.header' => 'Admin API documentation',
    'admin_api_documentation.subheader' => 'This is the documentation for the available API endpoints, only for the admins, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',

    'admin_api_documentation.users.header' => 'Users',
    'admin_api_documentation.users.update.status' => '0 - Disabled, 1 - Active, 2 - Banned',
    'admin_api_documentation.users.update.type' => '0 - Normal user, 1 - Admin',
    'admin_api_documentation.users.update.plan_id' => '\'free\', or an integer plan_id',
    'admin_api_documentation.users.update.plan_expiration_date' => 'Y-m-d H:i:s format in UTC timezone',
    'admin_api_documentation.users.update.plan_trial_done' => '0 - No, 1 - Yes',
    'admin_api_documentation.users.one_time_login_code_header' => 'Generate a one time login code',
    'admin_api_documentation.plans.header' => 'Plans',

    'admin_bulk_delete_modal.header' => 'Delete in bulk',
    'admin_bulk_delete_modal.subheader' => 'You\'ve selected multiple entries to be deleted, this may take a while & it action cannot be undone.',
    'admin_bulk_delete_modal.success_message' => 'The bulk deletion process was performed successfully.',
];
